
/**
 ******************************************************************************
 *
 * @file        MG32x02z_LM35DZ_API.c
 * @brief       Sample LM35DZ (Thermometer IC) by ADC. 
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_LM35DZ_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define DemoBoard_MCU_VDD   3334      // 3.334

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/
extern ADC_HandleTypeDef    mADC;

/**
 *******************************************************************************
 * @brief       Get thermometer data from LM35DZ 
 * @param[in]   None
 * @return      return LM35DZ data
 *******************************************************************************
 */
uint16_t API_LM35DZ_GetTemperature(void)
{
    uint32_t ADCSumDAT=0;
    
    ADC_ChannelConfTypeDef ADCChannelMux;
         
    /** Configure for the selected ADC regular channel to be converted.     **/
    ADCChannelMux.Channel = ADC_CHANNEL_3;
    MID_ADC_ConfigChannel(&mADC, &ADCChannelMux);
    
    // Trigger ADC Conversion
    MID_ADC_Start(&mADC);
    //  poll ADC flag
    MID_ADC_PollForConversion(&mADC, 10);
    
    
    ADCSumDAT = MID_ADC_GetValue(&mADC);
    
    // Convert to digital data
    ADCSumDAT = ADCSumDAT * DemoBoard_MCU_VDD;
    ADCSumDAT = ADCSumDAT / (4096 * 1000);
    
    ADCSumDAT = ADCSumDAT * 100;
    
    // return ADC result
    return (uint16_t) ADCSumDAT;
}








